## script for making geometry valid
## see https://r-spatial.org/r/2017/03/19/invalid.html for functio info

# read in data
countries <- st_read("world_countries_updated.shp")
qtm(countries)

# is the data valid?
valid <- st_is_valid(countries)
qtm(valid)

# make valid where we can
tmp2 <- st_make_valid(countries)
qtm(tmp2)

# try applying a buffer of distance 0.0 meters
tmp <- st_buffer(countries[!is.na(valid)], 0.0)

# check why the data isn't valid
table(st_is_valid(countries, reason = TRUE))
st_is_valid(countries, reason = TRUE)
st_is_valid(countries[918,])

table(st_is_valid(tmp2, reason = TRUE))
qtm(countries[146,])

# Africa data example (for where?) DEV GIS?

africa_v[918,] <- NULL
africa_b <- africa_v[-918,]

qtm(africa_b)

st_write(africa_b, "africa_c.shp")

africa_c <- st_read("africa_c.shp")

qtm(africa_c)

africa_b3 <- st_make_valid(africa_b2)

qtm(africa_b3)


table(st_is_valid(africa_c, reason = TRUE))
View(africa_c)

which(is.na(st_dimension(africa_c)))
africa_d <- africa_c[-is.na(st_dimension(africa_c)),]

st_make_valid(africa_c)

table(st_is_valid(africa_d, reason = TRUE))
qtm(africa_d)
which(is.na(st_dimension(africa_d)))

# see https://gis.stackexchange.com/questions/329110/removing-empty-polygon-from-sf-object-in-r

ne = africa_d[!st_is_empty(africa_d),,drop=FALSE]
ne
qtm(ne)
View(ne)

st_write(ne, "africa6.shp")

africa6 <- st_read("africa6.shp")
qtm(africa6)

##roads
roads <- st_read("Major_roads.shp")
st_is_valid(roads)
st_is_valid(roads, reason = TRUE)
table(st_is_valid(roads, reason = TRUE))

roads2 <- st_make_valid(roads)

st_is_valid(roads2)
st_is_valid(roads2, reason = TRUE)
table(st_is_valid(roads2, reason = TRUE))

qtm(roads2)
st_write(roads2, "Major_roads.shp")
         