## Chapter 9: If, If Else & Functions. 

# load the libraries
library(sf)
library(tmap)

# set working directory
#setwd("~/GIS/using-r-gis")
setwd("~/work/2020-24-intro-to-r-gis-book/data")
setwd("~/work/2020-24-using-r-scripts-TMP/data")

## 9.2 If Else statements in R

# run one of these lines to choose which data you want to load
data_filename <- "nga_ppp_2020_1km_Aggregated.tif"
data_filename <- "world_countries.shp"

# extract last3 characters of filename to determine filetype
format <- substr(data_filename,nchar(data_filename)-2,nchar(data_filename))

if ( format == "shp") {
  # map vector data
  data <- st_read(data_filename)
  tm_shape(data) +
    tm_polygons("POP2005", palette = "Greens", style = "jenks")
# need to update code
  
} else if ( format == "tif") {
  # map raster data
  library(terra)
  data <- rast(data_filename)
  plot(data)
  
} else {
  print("I don't know how to map this data.")
  print("It is not a shapefile (*.shp) or a tiff file (*.tif)")
}


## 9.3 Writing your own functions

Mapping <- function(data_filename) {
  # extract last3 characters of filename to determine filetype
  format <- substr(data_filename,nchar(data_filename)-2,nchar(data_filename))
  
  if ( format == "shp") {
    # map vector data
    data <- st_read(data_filename)
    tm_shape(data) +
      tm_polygons("POP2005", palette = "Greens", style = "jenks")
    
  } else if ( format == "tif") {
    # map raster data
    library(terra)
    data <- rast(data_filename)
    plot(data)
    
  } else {
    print("I don't know how to map this data.")
    print("It is not a shapefile (*.shp) or a tiff file (*.tif)")
    
  }
}

Mapping("world_countries.shp")


## Function for mapping different variables

MappingColumn <- function(data, column_name) {
  # setup map
  m <- tm_shape(data) +
    # set variable, colours and classes
    tm_polygons(column_name, palette = "Greens", style = "equal") +
    # set scale bar
    tm_scale_bar(width = 0.22, position = c(0.5, 0.01)) +
    # set compass
    tm_compass(position = c(0.8, 0.05)) + 
    # set layout
    tm_layout(frame = F, title = "Country Data", title.size = 2, 
              title.position = c(0.65, "top"))
  # save map
  tmap_save(m, filename = paste0("map-",column_name,".png"))
  # end function
}
# code needs to be updated

# examples of running the MappingColunm function
countries <- st_read("world_countries.shp")
MappingColumn(countries, "POP2005")
MappingColumn(countries, "LIFEEXP")
