## Chapter 8: Loops

# load the libraries
library(sf)
library(tmap)

# set working directory
#setwd("~/GIS/using-r-gis")
setwd("~/work/2020-24-intro-to-r-gis-book/data")
setwd("~/work/2020-24-using-r-scripts-TMP/data")

## follow the same steps as in Chapter 4 for loading and joining the data

# Read in a csv file
pop2015 <- read.csv("pop2015.csv")

# Read in a shapefile
countries <- st_read("world_countries.shp")
qtm(countries)

# join pop2015 data to countries data
countries <- merge(countries, pop2015, by.x="NAME", by.y="Name")

# do QTM map
qtm(countries,  fill="POP2015")

head(countries)

#v3
tm_shape(countries) + 
  tm_polygons("POP2015", palette = "Greens", style = "jenks")

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"))

## 8.1 Saving the Map in Code

#v3
m <- tm_shape(countries) +
  tm_polygons("POP2005", title = "POP2005", palette = "Greens", 
              style = "equal") +
  tm_scale_bar(width = 0.22, position = c(0.05, 0.10)) +
  tm_compass(position = c(0.3, 0.07)) + 
  tm_layout(frame = F, title = "Population 2005", title.size = 2, 
            title.position = c(0.7, "top"))

#v4
m <- tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
              tm_legend(title.size = 0.8)) +
  tm_place_legends_left(0.2) +
  tm_scalebar() + 
  ##north arrow
  tm_compass(size = 0.7, position=c("left", "bottom"))

# save map
tmap_save(m)

# save map
tmap_save(m)

# save map with a specified filename
tmap_save(m, filename = "map-Pop2005.png")

## Creating multiple maps at once

## 8.2 Creating multiple maps at once

# set which variables will be mapped
mapvariables <- c("POP2005", "LIFEEXP", "LIFEEXPM")

#v3
# loop through for each map
for (i in 1:length(mapvariables)) {
  # setup map
  m <- tm_shape(countries) +
    # set variable, colours and classes
    tm_polygons(mapvariables[i], palette = "Greens", style = "equal") +
    # set scale bar
    tm_scale_bar(width = 0.22, position = c(0.5, 0.01)) +
    # set compass
    tm_compass(position = c(0.8, 0.05)) + 
    # set layout
    tm_layout(frame = F, title = "Country Data", title.size = 2, 
              title.position = c(0.65, "top"))
  # save map
  tmap_save(m, filename = paste0("map-",mapvariables[i],".png"))
  # end loop
}

#v4 
# loop through for each map
for (i in 1:length(mapvariables)) {
  # setup map
  m <- tm_shape(countries) +
    tm_polygons(fill = mapvariables[i],
                fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
                tm_legend(title.size = 0.8)) +
    tm_place_legends_left(0.2) +
    tm_scalebar() + 
    ##north arrow
    tm_compass(size = 0.7, position=c("left", "bottom"))
  
  # save map
  tmap_save(m, filename = paste0("map-",mapvariables[i],".png"))
  # end loop
}

## Chapter 8 exercise: including multiple titles

# set which variables will be mapped
mapvariables <- c("POP2005", "LIFEEXP", "LIFEEXPM", "LIFEEXPF")
maptitles <- c("Population 2005", "Life Expectancy", "Male Life Expectancy", "Female Life Expectancy")

#v3
# loop through for each map
for (i in 1:length(mapvariables)) {
  # setup map
  m <- tm_shape(countries) +
    # set variable, colours and classes
    tm_polygons(mapvariables[i], palette = "Greens", style = "equal") +
    # set scale bar
    tm_scale_bar(width = 0.22, position = c(0.5, 0.01)) +
    # set compass
    tm_compass(position = c(0.8, 0.05)) + 
    # set layout
    tm_layout(frame = F, title = maptitles[i], title.size = 2, 
              title.position = c(0.65, "top"))
  # save map
  tmap_save(m, filename = paste0("map-",mapvariables[i],".png"))
  # end loop
}

#v4
# loop through for each map
for (i in 1:length(mapvariables)) {
  # setup map
  m <- tm_shape(countries) +
    tm_polygons(fill = mapvariables[i],
                fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
                tm_legend(title.size = 0.8)) +
    tm_place_legends_left(0.2) +
    tm_scalebar() + 
    ##north arrow
    tm_compass(size = 0.7, position=c("left", "bottom"))
  
  # save map
  tmap_save(m, filename = paste0("map-",mapvariables[i],".png"))
  # end loop
}
