## Chapter 7: Spatial Libraries - `sf` and `sp` 

# load the libraries, including sf which we have used already
library(sf)
library(tmap)

# set working directory
#setwd("~/GIS/using-r-gis")
setwd("~/work/2020-24-intro-to-r-gis-book/data")
setwd("~/work/2020-24-using-r-scripts-TMP/data")

# read in world countries as sf data type
countries_sf <- st_read("world_countries.shp")
# look at data
head(countries_sf)
qtm(countries_sf)

# sp which is the older library discussed in the chapter
# remember to install the libraries if you need to
# if these don't install, or give the error 
# package ‘rgdal’ is not available for this version of R
# then they have been completely retired, see the book chapter for details

library(sp)
library(rgdal) 
#note the warning about rgdal being retired during 2023 when you load this library

# read in countries data in sp format
countries_sp <- readOGR("world_countries_updated.shp")

# compare the classes
class(countries_sf)
class(countries_sp)

# compare the attribute tables
head(countries_sp@data)

# the different slotNames in sp
slotNames(countries_sp)
head(countries_sp@data)
countries_sp@polygons[1]
countries_sp@plotOrder
countries_sp@bbox
countries_sp@proj4string

## 7.2 Plotting Maps: a comparison

## sf

qtm(countries_sf)

qtm(countries_sf, fill = "POP2005")

tm_shape(countries_sf) +
  tm_polygons("POP2005", palette = "Greens", style = "jenks")

## sp

qtm(countries_sp)

qtm(countries_sp, fill = "POP2005")

tm_shape(countries_sp) + 
  tm_polygons("POP2005", palette = "Greens", style = "jenks")

# Plotting sp data without using tmap

# select variable
  var <- as.numeric(countries_sp@data$POP2005)
# set colours & breaks
  library(classInt)
  breaks <- classIntervals(var, n = 6, style = "fisher")
library(RColorBrewer)
my_colours <- brewer.pal(6, "Greens")
# plot map
  plot(countries_sp, col = my_colours[findInterval(var, breaks$brks, all.inside = TRUE)], axes = FALSE, 
     border = rgb(0.8,0.8,0.8))
# draw legend
  library(maptools)
  legend(x = -190.5203, y = 25.23282, legend = leglabs(breaks$brks), fill = my_colours, bty = "n", cex = 0.65)

## more details on the plan for future changes are listed at https://r-spatial.org/r/2022/04/12/evolution.html, with subsequent posts on https://r-spatial.org
