## Chapter 6: Interactive Maps

# load the libraries
library(sf)
library(tmap)

# set working directory
#setwd("~/GIS/using-r-gis")
setwd("~/work/2020-24-intro-to-r-gis-book/data")
setwd("~/work/2020-24-using-r-scripts-TMP/data")

## follow the same steps as in Chapter 4 for loading and joining the data

# Read in a csv file
pop2015 <- read.csv("pop2015.csv")

# Read in a shapefile
countries <- st_read("world_countries.shp")
qtm(countries)

# join pop2015 data to countries data
countries <- merge(countries, pop2015, by.x="NAME", by.y="Name")

# do QTM map
qtm(countries,  fill="POP2015")

## 6 Interactive Maps

# set to interactive / view mode
tmap_mode("view")

# draw basic interactive map
qtm(countries,  fill="POP2015")

# draw more advanced interactive map

#v3
tm_shape(countries) +
  tm_polygons("POP2015", palette = "Greens", style = "jenks")

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"))

# reset to plot mode
tmap_mode("plot")
