## Chapter 5: Raster Data

# install the library terra if you need to
#install.packages("terra")

# load the library
library(terra)

# set working directory
#setwd("~/GIS/using-r-gis")
setwd("~/work/2020-24-intro-to-r-gis-book/data")
setwd("~/work/2020-24-using-r-scripts-TMP/data")

# download data from https://hub.worldpop.org/geodata/summary?id=32968
# save the nga_ppp_2020_1km_Aggregated.tif file in your working directory
# if you can't download it, it is also available on the book website in ch5-data-worldpop.zip

# read in raster data
nigeriaPop <- rast("nga_ppp_2020_1km_Aggregated.tif")

# display summary
nigeriaPop
# Our data has one band (nlyr)

# resolution (in the CRS)
res(nigeriaPop)
# our data is in WGS84 (Lat/Long) so 0.0083... degrees = 1km

# what CRS is it using?
crs(nigeriaPop)

# plot data
plot(nigeriaPop)
# and add a title
plot(nigeriaPop, main = "Nigeria Population 2020")

# histogram
hist(nigeriaPop)
# log
plot(log10(nigeriaPop))

plot(log10(nigeriaPop), colNA="black", col=colorRampPalette(c("#121212", "#123620",
                                                              "#108650", "#80D6C0", "#DFDF3B"),0.5)(110))
# mapping with tmap
# load library
library(tmap)

# qtm
qtm(nigeriaPop)
# check code, long to calc on tmap v4 / RSutdio.cloud & crashes

# qtm + log
qtm(log10(nigeriaPop))
# check code, long to calc on tmap v4 / RSutdio.cloud & crashes

# tm_shape
#v4
tm_shape(nigeriaPop) +
  tm_raster()
#v3
tm_shape(nigeriaPop) +
  tm_raster(palette = "Greens")
# update code

tm_shape(nigeriaPop) + tm_raster(style = "fisher")
# fisher is quite computationally heavy, so might take while to run
# update code

tm_shape(nigeriaPop) + tm_raster(style = "log10_pretty")
# log10 pretty is quicker to calculate
# update code

# 5.5 Categorical Data

# you can download the data from https://land.copernicus.eu/en/products/corine-land-cover/clc-2000?hash=7be11e321982cd1df8a9e71b7ebf6e7839fd1424
# but it is a bit of a fiddly process so I have included it in the data you download from the book website. 

# read in the corine data
corine <- rast("corine/U2006_CLC2000_V2020_20u1.tif")

# plot data
plot(corine)


## 5.6 Cropping data

library(sf)

# read in world countries
countries <- st_read("world_countries.shp")

# plot data
qtm(countries)
head(countries)

# show entries in NAME column
countries$NAME

# find which one is UK
which(countries$NAME == "United Kingdom")

# double check R has the correct row, never assume!
head(countries[197,])
qtm(countries[197,])

# run the crop command
tmp <- crop(corine, countries[197,])
# R thinks the two layers do not overlap

# check coordinate reference system for 
# corine data
crs(corine)
# UK country data
crs(countries[197,])

# save UK as a new variable
UK <- countries[197,]

# reproject to the CRS the conrine data use (ETRS89,  LAEA Europe)
UK_new <- project(UK, crs(corine))
# R doesn't like this and gives us another error message

# check help for info
?project

# convert sf to SpatVector
UK_spatVect <- vect(UK)

# reproject (this time without errors!)
UK_new <- project(UK_spatVect, crs(corine))

# crop the data (again without errors!)
tmp <- crop(corine, UK_new)
# may crash rstudio cloud, check

# plot the map to check output
plot(tmp)
#v4 crashes on plot
