## Chapter 4: Choropleth Maps

# load the libraries
library(sf)
library(tmap)

# set working directory
#setwd("~/GIS/using-r-gis")
setwd("~/work/2020-24-intro-to-r-gis-book/data")
setwd("~/work/2020-24-using-r-scripts-TMP/data")

# Read in a csv file
pop2015 <- read.csv("pop2015.csv")
head(pop2015)

# Read in a shapefile

library(sf)
countries <- st_read("world_countries.shp")

library(tmap)
qtm(countries)

head(countries)

#join pop2015 data to countries data
countries <- merge(countries, pop2015, by.x="NAME", by.y="Name")

head(countries)

#View(countries)

#Code for Figure 4.4
qtm(countries,  fill="POP2015")

#v3
tm_shape(countries) +
  tm_polygons("POP2015")

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015")

#v3
tm_shape(countries) +
  tm_polygons("POP2015", palette = "Greens", style = "jenks")

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"))

## 4.4 Classifications

hist(countries$POP2015)

#select the variable
var <- countries$POP2015
#calculate the breaks
library(classInt)
breaks <- classIntervals(var, n = 6, style = "equal")
#draw histogram
hist(var)
#add breaks to histogram
abline(v = breaks$brks, col = "red")

# Equal Intervals

#v3
tm_shape(countries) +
  tm_polygons("POP2015", palette = "Greens", style = "equal", n = 6)

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "equal", n = 6),
              tm_legend(title.size = 0.8))

# Natural Breaks (Jenks / Fisher)

#v3
tm_shape(countries) +
       tm_polygons("POP2015", palette = "Greens", style = "jenks") +
       tm_layout(legend.title.size = 0.8)

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
              tm_legend(title.size = 0.8))

#select the variable
var <- countries$POP2015
#calculate the breaks
library(classInt)
breaks <- classIntervals(var, n = 5, style = "jenks")
#draw histogram
hist(var)
#add breaks to histogram
abline(v = breaks$brks, col = "red")

## 4.6 Beyond Colours

#v3
tm_shape(countries) +
  tm_polygons("POP2015", palette = "Greens", style = "jenks") +
  ##scale bar
  tm_scale_bar(width = 0.22, position = c(0.5, 0.01))

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
              tm_legend(title.size = 0.8)) +
  tm_scalebar()
# need to add some scalebar options

#v3
tm_shape(countries) +
  tm_polygons("POP2015", palette = "Greens", style = "jenks") +
  ##scale bar
  tm_scale_bar(width = 0.22, position = c(0.5, 0.01)) + 
  ##north arrow
  tm_compass(size = 0.7, position = c(0.78, 0.03))

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
              tm_legend(title.size = 0.8)) +
  tm_scalebar() + 
  ##north arrow
  tm_compass(size = 0.7, position = c(0.78, 0.03))

##Adding a Legend

#v3
tm_shape(countries) +
  tm_polygons("POP2015", palette = "Greens", style = "jenks") +
  #legend position
  tm_layout(legend.outside = TRUE, legend.outside.position = "bottom") +
  ##scale bar
  tm_scale_bar(width = 0.22, position = c(0.5, 0.01)) + 
  ##north arrow
  tm_compass(size = 0.7, position = c(0.78, 0.03))

#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
              tm_legend(title.size = 0.8)) +
  tm_place_legends_left(0.2) +
  tm_scalebar() + 
  ##north arrow
  tm_compass(size = 0.7, position = c(0.78, 0.03))
#legend may need some tweaking

#v4 
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"),
              tm_legend(title.size = 0.8)) +
  tm_place_legends_left(0.2) +
  tm_scalebar() + 
  ##north arrow
  tm_compass(size = 0.7, position=c("left", "bottom"))
#compass position may need some work, ?tm_lp_out() is not implemented yet

## 4.8 Dynamic Maps

#set tmap to view mode
tmap_mode("view")
#plot using qtm
qtm(countries)
#plot using tm_shape
#v3
tm_shape(countries) +
  tm_polygons("POP2015", palette = "Greens", style = "jenks")
#v4
tm_shape(countries) +
  tm_polygons(fill = "POP2015",
              fill.scale = tm_scale_intervals(values = "Greens", style = "jenks"))

#return tmap to plot mode
tmap_mode("plot")
